<div class="row">
    <div class="col-xs-12">
        <h4 class="header large lighter blue"><i class="fa fa-list" aria-hidden="true"></i>&nbsp;Fees List</h4>
        <div class="clearfix">
            <a class="label label-primary label-lg white" href="<?php echo e(route('print-out.fees.student-ledger', ['id' => $data['student']->id]), false); ?>" target="_blank">
                Ledger
                <i class="ace-icon fa fa-print  align-top bigger-125 icon-on-right"></i>
            </a>
            <a class="label label-warning label-lg white" href="<?php echo e(route('print-out.fees.student-due-detail', ['id' => $data['student']->id]), false); ?>" target="_blank">
                Due Detail Slip
                <i class="ace-icon fa fa-print  align-top bigger-125 icon-on-right"></i>
            </a>

            <a class="label label-warning label-lg white" href="<?php echo e(route('print-out.fees.student-due', ['id' => $data['student']->id]), false); ?>" target="_blank">
                Total Balance
                <i class="ace-icon fa fa-print  align-top bigger-125 icon-on-right"></i>
            </a>
            <a class="label label-success label-lg white" href="<?php echo e(route('print-out.fees.today-receipt-detail', ['id' => $data['student']->id]), false); ?>" target="_blank">
                Today Receipt Detail
                <i class="ace-icon fa fa-print  align-top bigger-125 icon-on-right"></i>
            </a>
            <a class="label label-success label-lg white" href="<?php echo e(route('print-out.fees.today-receipt', ['id' => $data['student']->id]), false); ?>" target="_blank">
                Receipt
                <i class="ace-icon fa fa-print  align-top bigger-125 icon-on-right"></i>
            </a>
            <a href="<?php echo e(route('account.fees.due.view', ['id' => $data['student']->id]), false); ?>" target="_blank" class="label label-primary label-lg white">
                <i class="ace-icon fa fa-calculator  align-top bigger-125 icon-on-right"></i>
                Collect Balance
            </a>
            <span class="hidden-print">
                <a class="btn-primary btn-sm" href="<?php echo e(route('account.fees.collection.view', ['id' => $data['student']->id]), false); ?>">
                     <i class="fa fa-calculator" aria-hidden="true"></i> View Ledger
                 </a>
            </span>

            <div class="hr hr-4 hr-dotted"></div>
            <div class="row text-uppercase">
                <div class="col-sm-5 pull-right align-right">
                    
                    <label class="label label-info label-lg white">Total Balance : <?php echo e(number_format($data['student']->balance, 2), false); ?>/-</label>
                </div>
                <div class="col-sm-7 pull-left">

                    <strong>Balance In Word:</strong> <?php echo e(ViewHelper::convertNumberToWord($data['student']->balance), false); ?>only.
                </div>
            </div>
            <div class="hr hr-8 hr-dotted"></div>
        </div>
        <!-- div.table-responsive -->
        <form id="bulk_action_form" method="get" action="<?php echo e(route('print-out.fees.selected-master-receipt'), false); ?>">
        <input type="hidden" name="studentId" value="<?php echo e(encrypt($data['student']->id), false); ?>" class="ace" />
        <div class="table-responsive">
            <table id="dynamic-table-1" class="table table-striped table-bordered table-hover">
                <thead class="header">
                    <tr role="row">
                        <th>S.No.</th>
                        <th>Sem</th>
                        <th>Head</th>
                        <th>DueDate</th>
                        <th>Amount </th>
                        <th>Dis. </th>
                        <th>Fine </th>
                        <th>Paid </th>
                        <th>Due </th>
                        <th>Status</th>
                        <th>
                            <a class="btn-primary btn-sm bulk-action-btn" target="_blank">
                                <i class="fa fa-print"></i> Print
                            </a>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($data['fee_master']) && $data['fee_master']->count() > 0): ?>
                        <?php ($i=1); ?>
                        <?php $__currentLoopData = $data['fee_master']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feemaster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i, false); ?></td>
                                <td><?php echo e(ViewHelper::getSemesterById($feemaster->semester), false); ?></td>
                                <td><?php echo e(ViewHelper::getFeeHeadById($feemaster->fee_head), false); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($feemaster->fee_due_date)->format('Y-m-d'), false); ?></td>
                                <td><?php echo e($feemaster->fee_amount, false); ?></td>
                                <td><?php echo e($feemaster->feeCollect()->sum('discount')?$feemaster->feeCollect()->sum('discount'):'-', false); ?></td>
                                <td><?php echo e($feemaster->feeCollect()->sum('fine')?$feemaster->feeCollect()->sum('fine'):'-', false); ?></td>
                                <td><?php echo e($feemaster->feeCollect()->sum('paid_amount')?$feemaster->feeCollect()->sum('paid_amount'):'-', false); ?></td>
                                <td>
                                    <?php ($net_balance = ($feemaster->fee_amount - ($feemaster->feeCollect()->sum('paid_amount')
                                    + $feemaster->feeCollect()->sum('discount')))+ $feemaster->feeCollect()->sum('fine')); ?>
                                    <?php echo e($net_balance?$net_balance:'-', false); ?>

                                </td>
                                <td align="left" class="text text-left">
                                    <?php if($net_balance == 0): ?>
                                        <span class="label label-success">Paid</span>
                                    <?php elseif($net_balance < 0 ): ?>
                                        <span class="label label-warning">Negative</span>
                                    <?php elseif($net_balance < $feemaster->fee_amount): ?>
                                        <span class="label label-info">Partial</span>
                                    <?php else: ?>
                                        <span class="label label-danger">Due</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                   
                                    

                                    <label>
                                        <input type="checkbox" name="chkIds[]" value="<?php echo e($feemaster->id, false); ?>" class="ace" />
                                        <span class="lbl"></span>
                                    </label>
                                </td>
                                
                            </tr>
                            <?php ($i++); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr style="font-size: 14px; background: orangered;color: white;">
                                <td colspan="4">Total</td>
                                <td><?php echo e($data['student']->fee_amount?$data['student']->fee_amount:'-', false); ?></td>
                                <td><?php echo e($data['student']->discount?$data['student']->discount:'-', false); ?></td>
                                <td><?php echo e($data['student']->fine?$data['student']->fine:'-', false); ?></td>
                                <td><?php echo e($data['student']->paid_amount?$data['student']->paid_amount:'-', false); ?></td>
                                <td>
                                    <?php echo e($data['student']->balance?$data['student']->balance:'-', false); ?>

                                </td>
                                <td>
                                    <?php if($data['student']->balance == 0): ?>
                                        <span class="label label-success">Paid</span>
                                    <?php elseif($data['student']->balance < 0 ): ?>
                                        <span class="label label-warning">Negative</span>
                                    <?php elseif($data['student']->balance < $data['student']->fee_amount): ?>
                                        <span class="label label-warning">Partial</span>
                                    <?php else: ?>
                                        <span class="label label-danger">Due</span>
                                    <?php endif; ?>
                                </td>
                                <td></td>
                            </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        </form>
    </div>
</div><?php /**PATH C:\xampp\htdocs\larvel-project\collegeaccounting\resources\views/student/detail/includes/fees.blade.php ENDPATH**/ ?>