<div class="col-xs-12">
    <h4 class="header large lighter blue"><i class="fa fa-list" aria-hidden="true"></i>&nbsp;
        <?php echo e(strtoupper(isset($data['transactionHead'])?$data['transactionHead']->tr_head:''), false); ?> -
        <?php echo e(strtoupper(isset($data['transactionHead'])?ViewHelper::getAcGroupById($data['transactionHead']->acc_id):''), false); ?>

    </h4>
    <div class="clearfix">
        <span class="pull-right tableTools-container"></span>

        <?php echo Form::open(['route' => ['account.transaction-head.view'], 'method' => 'GET', 'class' => 'form-horizontal',
                        'id' => 'validation-form', "enctype" => "multipart/form-data"]); ?>

        <div class="form-horizontal" id="filterDiv">
            <div class="form-group">
                <?php echo Form::hidden('tr_head', isset($data['transactionHead']->id)?$data['transactionHead']->id:'', ["class" => "input-sm form-control border-form"]); ?>

                <?php echo Form::label('tr_date', 'Date Range', ['class' => 'col-sm-2 control-label']); ?>

                <div class=" col-sm-4">
                    <div class="input-group ">
                        <?php echo Form::text('tr_start_date', null, ["placeholder" => "YYYY-MM-DD", "class" => "input-sm form-control border-form input-mask-date date-picker", "data-date-format" => "yyyy-mm-dd"]); ?>

                        <span class="input-group-addon">
                            <i class="fa fa-exchange"></i>
                    </span>
                        <?php echo Form::text('tr_end_date', null, ["placeholder" => "YYYY-MM-DD", "class" => "input-sm form-control border-form input-mask-date date-picker", "data-date-format" => "yyyy-mm-dd"]); ?>


                    </div>
                </div>
                <button class="btn btn-info btn-sm" type="submit">
                    <i class="fa fa-filter"></i>
                    Filter
                </button>
            </div>
        </div>
        <?php echo Form::close(); ?>

    </div>
    <div class="table-header">
        Service Record list on table. Filter list using search box as your Wish.
    </div>
    <!-- div.table-responsive -->
    <div class="table-responsive">
        <table id="dynamic-table" class="table table-striped table-bordered table-hover">
            <thead class="header">
            <tr role="row">
                <th>S.N.</th>
                <th>Date</th>
                <th>Description</th>
                <th>Debit (+)</th>
                <th>Credit (-)</th>
                <th>Balance</th>
            </tr>
            </thead>

            <?php if(isset($data['transaction']) && $data['transaction']->count() > 0): ?>
                <tbody>
                <?php ($i=1); ?>
                <?php $__currentLoopData = $data['transaction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i, false); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($transaction->date)->format('Y-m-d'), false); ?></td>
                        <td><?php echo e($transaction->description, false); ?></td>
                        <td align="right"><?php echo e($transaction->dr_amount, false); ?></td>
                        <td align="right"><?php echo e($transaction->cr_amount, false); ?></td>
                        <?php if(is_numeric($transaction->balance) && $transaction->balance >= 0): ?>
                            <td align="right"><?php echo e($transaction->balance, false); ?></td>
                        <?php else: ?>
                            <td class="red" align="right"><?php echo e($transaction->balance, false); ?></td>
                        <?php endif; ?>
                    </tr>
                    <?php ($i++); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                <tr style="font-size: 14px; background: orangered;color: white;">
                    <td></td>
                    <td></td>
                    <td colspan="" align="right"><b>Grand Total:</b></td>
                    <td align="right"><b><?php echo e($drTotal = $data['transaction']->sum('dr_amount'), false); ?></b></td>
                    <td align="right"><b><?php echo e($crTotal = $data['transaction']->sum('cr_amount'), false); ?></b></td>
                    <td align="right"><b><?php echo e($drTotal - $crTotal, false); ?></b></td>
                </tr>
                </tfoot>
            <?php else: ?>
                <tr>
                    <td colspan="6">No <?php echo e($panel, false); ?> data found. Please Filter <?php echo e($panel, false); ?> to show. </td>
                </tr>
            <?php endif; ?>
        </table>
    </div>
</div>
<?php /**PATH /home/software/demo.softwarelinkers.in/new_school_accounting_software/resources/views/staff/detail/includes/transaction.blade.php ENDPATH**/ ?>