<hr class="hr hr-2">
<div class="row align-center">
    <span class="receipt-copy">Online Payments List</span>
</div>
<hr class="hr hr-2">

<table width="100%" class="table-bordered">
    <thead>
    <tr>
        <th >S.N.</th>
        <th>Faculty/Class</th>
        <th>Sem./Sec.</th>
        <th>Reg.Num.</th>
        <th>Name</th>
        <th>Date</th>
        <th>Gateway</th>
        <th>Amount</th>
        <th>PaidBy</th>
        <th>Status</th>
    </tr>
    </thead>
    <tbody>
    <?php if(isset($data['student']) && $data['student']->count() > 0): ?>
        <?php ($i=1); ?>
        <?php $__currentLoopData = $data['student']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($i, false); ?></td>
                <td> <?php echo e(ViewHelper::getFacultyTitle( $student->faculty ), false); ?></td>
                <td> <?php echo e(ViewHelper::getSemesterTitle( $student->semester ), false); ?></td>
                <td> <?php echo e($student->reg_no, false); ?></td>
                <td> <?php echo e($student->first_name.' '.$student->middle_name.' '. $student->last_name, false); ?></td>
                <td class="text-center"><?php echo e(\Carbon\Carbon::parse($student->date)->format('Y-m-d'), false); ?> </td>
                <td><?php echo e($student->payment_gateway, false); ?></td>
                <td class="text-right"><?php echo e($student->amount, false); ?></td>
                <td class="text-center"><?php echo e(ViewHelper::getUserNameId($student->paid_by), false); ?></td>
                <td class="text-center">
                    <?php echo e($student->payment_status == 0?'Not Verify':'Verified', false); ?>

                </td>
            <?php ($i++); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <tr>
            <td colspan="10">No <?php echo e($panel, false); ?> data found. Please Filter <?php echo e($panel, false); ?> to show. </td>
        </tr>
    <?php endif; ?>
    </tbody>
    <tfoot>
        <tr style="font-size: 14px; font-weight: bold; background: orangered;color: white;">
            <td colspan="7" class="text-right">Total</td>
            <td  class="text-right"><?php echo e($data['student']->sum('amount'), false); ?></td>
            <td></td>
            <td></td>
        </tr>
    </tfoot>
</table>
<?php /**PATH /home/software/demo.softwarelinkers.in/new_school_accounting_software/resources/views/account/report/online-payment/includes/table.blade.php ENDPATH**/ ?>