<div class="form-horizontal">
    <div class="row">
        <div class="col-xs-12">
            <h4 class="header large lighter blue"><i class="fa fa-list" aria-hidden="true"></i>&nbsp;<?php echo e($panel, false); ?> List</h4>
            <div class="clearfix">
            <span class="easy-link-menu">
                <a class="btn-primary btn-sm bulk-action-btn" attr-action-type="complete"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;Complete</a>
                <a class="btn-warning btn-sm bulk-action-btn" attr-action-type="pending"><i class="fa fa-remove" aria-hidden="true"></i>&nbsp;Pending</a>
                <a class="btn-danger btn-sm bulk-action-btn" attr-action-type="delete"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;Delete</a>
            </span>

                <span class="pull-right tableTools-container"></span>
            </div>
            <div class="table-header">
                <?php echo e($panel, false); ?>  Record list on table. Filter <?php echo e($panel, false); ?> using the filter.
            </div>
        <!-- div.table-responsive -->
            <div class="table-responsive">
                <?php echo Form::open(['route' => $base_route.'.bulk-action', 'id' => 'bulk_action_form']); ?>

                <table id="dynamic-table" class="table table-striped table-bordered table-hover">
                    <thead class="text-center">
                    <tr>
                        <th class="center">
                            <label class="pos-rel">
                                <input type="checkbox" class="ace" />
                                <span class="lbl"></span>
                            </label>
                        </th>
                        <th>S.N.</th>
                        <th>SEM/SEC</th>
                        <th>Subject/Course</th>
                        <th>Topic</th>
                        
                        
                        <th>Start Time</th>
                        
                        <th>MIN</th>
                        <th>Schedule By</th>
                        <th>Status</th>
                        <th>LINK</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(isset($data['meetings']) && $data['meetings']->count() > 0): ?>
                        <?php ($i=1); ?>
                        <?php $__currentLoopData = $data['meetings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="center first-child">
                                    <label>
                                        <input type="checkbox" name="chkIds[]" value="<?php echo e(encrypt($meeting->id), false); ?>" class="ace" />
                                        <span class="lbl"></span>
                                    </label>
                                </td>
                                <td><?php echo e($i, false); ?></td>
                                <td><?php echo e(ViewHelper::getSemesterById($meeting->semesters_id), false); ?></td>
                                <td><?php echo e(ViewHelper::getSubjectById($meeting->subjects_id), false); ?></td>
                                <td> <?php echo e($meeting->topic, false); ?> </td>
                                
                                
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($meeting->start_time)->format('D, d-M-Y | H:i:s A'), false); ?>

                                </td>
                                
                                <td> <?php echo e($meeting->duration, false); ?> </td>
                                <td> <?php echo e($meeting->created_by_name, false); ?> </td>
                                <td>
                                    <div class="btn-group">
                                        <button data-toggle="dropdown" class="btn btn-primary btn-minier dropdown-toggle <?php echo e($meeting->status == 'active'?"btn-info":"btn-warning", false); ?>" >
                                            
                                            <?php if( $meeting->status == 'active'): ?>
                                                Complete
                                            <?php elseif( $meeting->status == 'in-active'): ?>
                                                Pending
                                            <?php else: ?>
                                                Start
                                            <?php endif; ?>
                                            <span class="ace-icon fa fa-caret-down icon-on-right"></span>
                                        </button>

                                        <ul class="dropdown-menu">
                                            <li>
                                                <a href="<?php echo e(route($base_route.'.pending', ['id' => encrypt($meeting->id)]), false); ?>" title="Pending"><i class="fa fa-remove" aria-hidden="true"></i> Pending</a>
                                            </li>

                                            <li>
                                                <a href="<?php echo e(route($base_route.'.start', ['id' => encrypt($meeting->id)]), false); ?>" title="Start"><i class="fa fa-line-chart" aria-hidden="true"></i> Start</a>
                                            </li>

                                            <li>
                                                <a href="<?php echo e(route($base_route.'.complete', ['id' => encrypt($meeting->id)]), false); ?>" title="Complete"><i class="fa fa-check" aria-hidden="true"></i> Complete</a>
                                            </li>


                                        </ul>
                                    </div>
                                </td>
                                <td>
                                    
                                    <?php if(((\Carbon\Carbon::parse($meeting->start_time))->addMinutes($meeting->duration)) > \Carbon\Carbon::now()): ?>

                                        <?php if($meeting->status != 'active'): ?>
                                            <div class="action-buttons">
                                                <a href="<?php echo e($meeting->start_url, false); ?>" target="_blank" title="Start" class="btn-success btn-sm">
                                                    <i class="fa fa-video-camera" aria-hidden="true"></i> Start
                                                </a>
                                                <a href="<?php echo e(route($base_route.'.send-alert', ['event' => 'schedule', 'id' => encrypt($meeting->id)]), false); ?>" target="_blank" title="Start" class="btn-warning btn-sm">
                                                    <i class="fa fa-send" aria-hidden="true"></i> Alert/Invite
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="red">
                                            Expire:<?php echo e(((\Carbon\Carbon::parse($meeting->start_time))->addMinutes($meeting->duration))->diffForHumans(), false); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if( $meeting->status == 'in-active'): ?>
                                    <div class="action-buttons">
                                        <a href="<?php echo e(route($base_route.'.delete', ['id' => encrypt($meeting->id)]), false); ?>" class="red bootbox-confirm">
                                            <i class="ace-icon fa fa-trash-o bigger-130"></i>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php ($i++); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="12">No <?php echo e($panel, false); ?> data found. Please Filter <?php echo e($panel, false); ?> to show. </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>

<?php /**PATH C:\xampp\htdocs\larvel-project\collegeaccounting\resources\views/meeting/includes/table.blade.php ENDPATH**/ ?>