@extends('layouts.master')
@section('top-script')

@endSection
@section('css')
    <!-- page specific plugin styles -->

@endsection

@section('content')
    <div class="main-content">
        <div class="main-content-inner">
            <div class="page-content">
                @include('layouts.includes.template_setting')
                <div class="page-header">
                    <h1>
                        Pesaple Payment
                        <small>
                            <i class="ace-icon fa fa-angle-double-right"></i>
                            Request Form (Kenya)
                        </small>
                    </h1>
                </div><!-- /.page-header -->

                <div class="row">
                    @include('includes.flash_messages')
                    <div class="col-xs-12 ">
                        <div class="easy-link-menu align-right">
                            <img alt="PayUMoney Payment Request Form" src="{{ asset('assets/images/paymenticon/pesapal.png') }}" width="150px" />
                        </div>
                        <h4 class="header large lighter blue">Mandatory Parameters</h4>
                        <form action="{{route('account.fees.pesapal')}}"  name="pesapalForm" method=POST class="form-horizontal">
                            <div class="form-group">
                                <input type="text" name="reference" value="{{$data['reference']}}" />
                                <input type="text" name="type" value="MERCHANT" />
                            </div>
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Amount:</label>
                                <div class="col-sm-4">
                                    <input name="amount" value="{{$data['amount']}}" class="input-sm form-control border-form" required/>
                                </div>

                                <label class="col-sm-2 control-label">Email:</label>
                                <div class="col-sm-4">
                                    <input name="email" id="email" value="{{$data['email']}}"  class="input-sm form-control border-form" required />
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">First Name:</label>
                                <div class="col-sm-4">
                                    <input name="firstname" id="firstname" value="{{$data['firstname']}}"   class="input-sm form-control border-form" required />
                                </div>

                                <label class="col-sm-2 control-label">Last Name:</label>
                                <div class="col-sm-4">
                                    <input name="lastname" id="lastname" value="{{$data['lastname']}}"   class="input-sm form-control border-form" />
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Phone:</label>
                                <div class="col-sm-4">
                                    <input name="phone" value="{{$data['phone']}}"  class="input-sm form-control border-form" required />
                                </div>

                                <label class="col-sm-2 control-label">Pay For :</label>
                                <div class="col-sm-4">
                                    <textarea name="description" required class="input-sm form-control border-form" readonly>{{$data['description']}}</textarea>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="clearfix form-actions">
                                    <div class="align-right">
                                        <button class="btn btn-info" type="submit" value="Submit">
                                            Pay Now With Pesapal
                                        </button>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div>
        </div><!-- /.page-content -->
    </div>
    </div><!-- /.main-content -->
@endsection


@section('js')

@endsection


{{--$amount = $_POST['amount'];
$amount = number_format($amount, 2);//format amount to 2 decimal places

$desc = $_POST['description'];
$type = $_POST['type']; //default value = MERCHANT
$reference = $_POST['reference'];//unique order id of the transaction, generated by merchant
$first_name = $_POST['first_name'];
$last_name = $_POST['last_name'];
$email = $_POST['email'];
$phonenumber = '';//ONE of email or phonenumber is required--}}