<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('beds', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();

            $table->unsignedInteger('created_by');
            $table->unsignedInteger('last_updated_by')->nullable();

            $table->unsignedInteger('hostels_id');
            $table->unsignedInteger('rooms_id');
            $table->integer('bed_number');
            $table->unsignedInteger('bed_status')->default(1);

            $table->foreign('hostels_id')->references('id')->on('hostels');
            $table->foreign('rooms_id')->references('id')->on('rooms');
            $table->foreign('bed_status')->references('id')->on('bed_statuses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('beds');
    }
}
